# Tools & Libraries

## Component Library

### Toolbox

* [Storybook.js](https://storybook.js.org/) (storybook.js.org)
* [StoryShots](https://github.com/storybookjs/storybook/tree/master/addons/storyshots/storyshots-core) (github.com)

### Tutorials

* [What is Storybook and How Can I Use It to Create a Component Library in React?](https://www.freecodecamp.org/news/what-is-storybook-and-how-can-i-use-it-to-create-a-component-libary-in-react/) (freecodecamp.org)

## Custom React Hook

### Toolbox

* [React Hooks](https://reactjs.org/docs/hooks-reference.html) (reactjs.org)
* [The Lord of the Rings API](https://the-one-api.herokuapp.com/documentation) (the-one-api.herokuapp.com)
* [useCustomHook](https://github.com/colbyfayock/use-custom-hook) (github.com)

### Tutorials

* [How to Create a Custom React Hook and Publish it to npm](https://www.freecodecamp.org/news/how-to-create-a-custom-react-hook-and-publish-it-to-npm/) (freecodecamp.org)
* [Destructuring the Fundamentals of React Hooks](https://www.colbyfayock.com/2019/04/destructuring-the-fundamentals-of-react-hooks) (colbyfayock.com)

## Framework Theme

### Toolbox

* [Gatsby Themes](https://www.gatsbyjs.org/docs/themes/) (gatsbyjs.org)
* [Tailwind](https://tailwindcss.com/) (tailwindcss.com)

### Tutorials

* [Building a Theme](https://www.gatsbyjs.org/tutorial/building-a-theme/) (gatsbyjs.org)
* [What is Tailwind CSS and How Can I Add it to my Website or React App?](https://www.freecodecamp.org/news/what-is-tailwind-css-and-how-can-i-add-it-to-my-website-or-react-app/) (freecodecamp.org)

### Inspiration

* [Gatsby Tailwind Theme](https://github.com/talensjr/gatsby-theme-tailwindcss) (github.com)

## CSS Animation Library

### Toolbox

* [Sass](https://sass-lang.com/) (sass-lang.com)

### Tutorials

* [How to Use Pure CSS to Create a Beautiful Loading Animation for your App](https://www.freecodecamp.org/news/how-to-use-css-to-create-a-beautiful-loading-animation-for-your-app/) (freecodecamp.org)

### Inspiration

* [Animate.css](https://animate.style/) (animate.style)
* [Pure CSS Loaders](https://loading.io/css/) (loading.io)

## Custom GitHub Action

### Toolbox

* [Slack API](https://api.slack.com/) (api.slack.com)
* [ncc](https://github.com/vercel/ncc) (github.com)

### Tutorials

* [What are Github Actions and How Can You Automate Tests and Slack Notifications?](https://www.freecodecamp.org/news/what-are-github-actions-and-how-can-you-automate-tests-and-slack-notifications/) (freecodecamp.org)
* [Create a New Github Action to Automate Code Tasks with Javascript](https://egghead.io/playlists/create-a-new-github-action-to-automate-code-tasks-with-javascript-f1e9?af=atzgap) (egghead.io)

### Inspiration

Know of any good examples? Submit a Pull Request!

## Framework Starter

### Toolbox

* [Next.js](https://nextjs.org/) (nextjs.org)
* [MDX](https://mdxjs.com/) (mdxjs.com)

### Tutorials

* [Building a Blog with Next.js](https://css-tricks.com/building-a-blog-with-next-js/) (css-tricks.com)
* [MDX: Next.js](https://mdxjs.com/getting-started/next) (mdxjs.com)
* [Use MDX in Next.js to Dynamically Create Pages for a Blog](https://youtu.be/1-1ZLAHpa2U) (youtube.com)
* [Next.js with Headless WordPress - GraphQL Queries with WPGraphQL & Deploy to Netlify](https://youtu.be/X8fY011u0tE) (youtube.com)

### Inspiration

* [Next + MDX Digital Garden Starter](https://github.com/RyanWarner/next-mdx-digital-garden-starter/) (github.com)
* [Next Wordpress Starter](https://github.com/colbyfayock/next-wordpress-starter) (github.com)

---

## Know of any other good resources?

If you know of a great tutorial or another tool that can help others, open a pull request with a link!
